(*--------------------------------------------------------------------**
**	    	Fa. MAMAvision Software Consult                             **
**		    Wollmatingerstrae 70b  D-78467 Konstanz                    **
**	      Tel.: (07531)690014     Fax: (07531)690015                  **
**--Projekt-----------------------------------------------------------**
**		               	 MMComponents Registrier-Unit                   **
**                     SOFTWARE\MMPLOT\VCL\....                       **
**--Revisionhistory---------------------------------------------------**
**
log
**
**--Module------------------------------------------------------------**
**  Modul-Name      : modname
**  Modul-Revision  : version
**  Projekt-Revision: release
**--------------------------------------------------------------------**
nokeywords
**--------------------------------------------------------------------*)
unit MMReg;
(*--------------------------------------------------------------------*)
(*   Component-Registration                                           *)
(*--------------------------------------------------------------------*)
interface

uses DsgnIntf, Classes;

type
  TGraphDirProperty = class(TPropertyEditor)
  public
    function  GetValue: string; override;
    procedure SetValue(const Value: string); override;
    function  GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

  TGraphNameProperty = class(TPropertyEditor)
  public
    function  GetValue: string; override;
    procedure SetValue(const Value: string); override;
    function  GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

{$define ENGLISH}        (* Remove $ if German required *)
const
{$ifdef ENGLISH}
  txt_Filter  = 'Plotfiles (*.plt,*.hpg)|*.plt;*.hpg|All Files (*.*)|*.*|';
  txt_DefaultPage = 'Samples';
{$else}
  txt_Filter   = 'Plotdateien (*.plt,*.hpg)|*.plt;*.hpg|Alle Dateien (*.*)|*.*|';
  txt_DefaultPage = 'Beispiele';
{$endif}

procedure Register;

implementation

uses SysUtils, Dialogs, FileCtrl, Inifiles, LibConst,
     MMPlot_U;

{ TGraphDirProperty }

function TGraphDirProperty.GetValue: string;
begin
  Result := (GetComponent(0) as TGraph).GraphDir;
end;

procedure TGraphDirProperty.SetValue(const Value: string);
begin
  (GetComponent(0) as TGraph).GraphDir := Value;
end;

function TGraphDirProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog, paMultiSelect];
end;

procedure TGraphDirProperty.Edit;
var
  FilePath: TFileName;
begin
  FilePath := LowerCase((GetComponent(0) as TGraph).GraphDir);
  if SelectDirectory(FilePath, { startdirectory }
                     [],       { options }
                     0)        { Helpcontext }
                      then
  begin
    if FilePath[Length(FilePath)] <> '\' then FilePath := FilePath + '\';
    (GetComponent(0) as TGraph).GraphDir := LowerCase(FilePath);
    If Designer <> nil then Designer.modified;
  end;
end;

{ TGraphNameProperty }

function TGraphNameProperty.GetValue: string;
begin
  Result := (GetComponent(0) as TGraph).GraphName;
end;

procedure TGraphNameProperty.SetValue(const Value: string);
begin
  (GetComponent(0) as TGraph).GraphName := Value;
end;

function TGraphNameProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog, paMultiSelect];
end;

procedure TGraphNameProperty.Edit;
var
  Dialog: TOpenDialog;
  FilePath: string;
begin
  Dialog := TOpenDialog.Create(nil);
  try
    with Dialog do
    begin
      DefaultExt := 'plt';
      Options := Options + [ofHideReadOnly,ofShareAware];
      Initialdir := LowerCase((GetComponent(0) as TGraph).GraphDir);
      Filename   := LowerCase((GetComponent(0) as TGraph).GraphName);
      Filter := txt_Filter;
      if Execute then
      begin
        with GetComponent(0) as TGraph do
        begin
          Dialog.FileName := LowerCase(Dialog.FileName);
          FilePath := ExtractFilePath(Dialog.FileName);
          if GraphDir = FilePath then
            GraphName := ExtractFileName(Dialog.FileName)
          else begin
            GraphDir := FilePath;
            GraphName := ExtractFileName(Dialog.FileName);
          end;
        end;
        If Designer <> nil then Designer.modified;
      end;
    end;
  finally
    Dialog.Free;
  end;
end;


(*******************************************************************)

procedure Register;
begin
{ registers this VCL components and adds the icons to the palette }
  RegisterComponents('Samples', [TMMPlot]);
  RegisterPropertyEditor(TypeInfo(string), TGraph, 'GraphDir', TGraphDirProperty);
  RegisterPropertyEditor(TypeInfo(string), TGraph, 'GraphName', TGraphNameProperty);
end;
end.
